/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client;

import java.io.IOException;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.console.Console;
import net.caffeinemc.mods.sodium.client.console.message.MessageLevel;
import net.caffeinemc.mods.sodium.client.data.fingerprint.FingerprintMeasure;
import net.caffeinemc.mods.sodium.client.data.fingerprint.HashedFingerprint;
import net.caffeinemc.mods.sodium.client.gui.SodiumDebugEntry;
import net.caffeinemc.mods.sodium.client.gui.SodiumOptions;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.caffeinemc.mods.sodium.mixin.features.gui.hooks.debug.DebugScreenEntriesAccessor;
import net.minecraft.class_11632;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumClientMod {
    private static SodiumOptions OPTIONS;
    private static final Logger LOGGER;
    public static final class_2960 SODIUM_DEBUG_ENTRY_FULL;
    public static final class_2960 SODIUM_DEBUG_ENTRY_REDUCED;
    private static String MOD_VERSION;

    public static void onInitialization(String version) {
        Map<class_2960, class_11632> entries = DebugScreenEntriesAccessor.getEntries();
        entries.put(SODIUM_DEBUG_ENTRY_FULL, new SodiumDebugEntry(true));
        entries.put(SODIUM_DEBUG_ENTRY_REDUCED, new SodiumDebugEntry(false));
        MOD_VERSION = version;
        OPTIONS = SodiumClientMod.loadConfig();
        try {
            SodiumClientMod.updateFingerprint();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to update fingerprint", t);
        }
    }

    public static SodiumOptions options() {
        if (OPTIONS == null) {
            throw new IllegalStateException("Config not yet available");
        }
        return OPTIONS;
    }

    public static Logger logger() {
        if (LOGGER == null) {
            throw new IllegalStateException("Logger not yet available");
        }
        return LOGGER;
    }

    private static SodiumOptions loadConfig() {
        try {
            return SodiumOptions.loadFromDisk();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load configuration file", (Throwable)e);
            LOGGER.error("Using default configuration file in read-only mode");
            Console.instance().logMessage(MessageLevel.SEVERE, "sodium.console.config_not_loaded", true, 12.5);
            SodiumOptions config = SodiumOptions.defaults();
            config.setReadOnly();
            return config;
        }
    }

    public static void restoreDefaultOptions() {
        OPTIONS = SodiumOptions.defaults();
        try {
            SodiumOptions.writeToDisk(OPTIONS);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file", e);
        }
    }

    public static String getVersion() {
        if (MOD_VERSION == null) {
            throw new NullPointerException("Mod version hasn't been populated yet");
        }
        return MOD_VERSION;
    }

    private static void updateFingerprint() {
        FingerprintMeasure current = FingerprintMeasure.create();
        if (current == null) {
            return;
        }
        HashedFingerprint saved = null;
        try {
            saved = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load existing fingerprint", t);
        }
        if (saved == null || !current.looselyMatches(saved)) {
            HashedFingerprint.writeToDisk(current.hashed());
            SodiumClientMod.OPTIONS.notifications.hasSeenDonationPrompt = false;
            SodiumClientMod.OPTIONS.notifications.hasClearedDonationButton = false;
            try {
                SodiumOptions.writeToDisk(OPTIONS);
            }
            catch (IOException e) {
                LOGGER.error("Failed to update config file", (Throwable)e);
            }
        }
    }

    public static boolean allowDebuggingOptions() {
        return PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment();
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"Sodium");
        SODIUM_DEBUG_ENTRY_FULL = class_2960.method_60655((String)"sodium", (String)"debug_full");
        SODIUM_DEBUG_ENTRY_REDUCED = class_2960.method_60655((String)"sodium", (String)"debug_reduced");
    }
}

